Imports System.Collections

'
' Instances of this class are used to create and send e-mail messages.
' It assumes that an e-mail message consists of a message body and zero or
' more attachments. The content of the message body must be provided as
' either a String object or an object that implements an interface called
' RichText.  Any kind of an object can be provided as the content of an
' attachment. 
'
Public Class MessageCreator
    ' Enum to indicate the type of message to create
    Public Enum MessageType As Integer
        MIME
        MAPI
        NOTES
        BANYAN
    End Enum

    Private myHeaderFields As New Hashtable()
    Private myMessageBody As RichText
    Private myAttachments As New ArrayList()
    Private mySignMessage As Boolean
    Private myMessageType As MessageType

    '
    ' Constructor to create a MessageCreator object that will create an
    ' e-mail message and send it to the given address.  It will attempt to
    ' infer the type of message to create from the "to" address.
    '
    ' sendTo - The address that this object will send a message to.
    ' from - The address that the message will say it is from.
    ' subject - The subject of this message.
    '
    Public Sub New(ByVal sendto As String, ByVal from As String, ByVal subject As String)
        MyClass.New(sendto, from, subject, InferMessageType(sendto))
    End Sub

    '
    ' Constructor to create a MessageCreator object that will create an
    ' e-mail message and send it to the given address.
    '
    ' sendTo - The address that this object will send a message to.
    ' from - The address that the message will say it is from.
    ' subject -  The subject of this message.
    ' type -  The type of message to create.
    '
    Public Sub New(ByVal sendto As String, ByVal from As String, ByVal subject As String, ByVal type As MessageType)
        myHeaderFields("to") = sendto
        myHeaderFields("from") = from
        myHeaderFields("subject") = subject
        myMessageType = type
    End Sub

    '...

    ' The contents of the message body.
    Public Sub SetMessageBody(ByVal value As String)
        MessageBody = New RichTextString(value)
    End Sub

    ' The contents of the message body.
    Public WriteOnly Property MessageBody() As RichText
        Set(ByVal Value As RichText)
            Me.myMessageBody = Value
        End Set
    End Property

    ' Add an attachement to the message
    ' attachment - the object to attach to the message
    Public Sub AddAttachment(ByVal attachment As Object)
        myAttachments.Add(attachment)
    End Sub

    ' Flag whether this message should be signed.  The default is false.
    Public WriteOnly Property SignMessage() As Boolean
        Set(ByVal Value As Boolean)
            mySignMessage = Value
        End Set
    End Property

    ' Set the value of a header field.
    ' name - The name of the field to set the value of
    ' value - The value to set the field to.
    Public Sub SetHeaderField(ByVal name As String, ByVal value As String)
        myHeaderFields(name.ToLower()) = value
    End Sub

    ' Send the message
    Public Sub Send()
        Dim body As New MessageBody(myMessageBody)
        For i As Integer = 0 To myAttachments.Count - 1
            body.AddAttachment(New Attachment(myAttachments(i)))
        Next i
        Dim header As New MessageHeader(myHeaderFields)
        Dim msg As New Message(header, body)
        If mySignMessage Then
            msg.Security = CreateSecurity()
        End If
        CreateMessageSender(msg)
    End Sub 'Send

    '
    ' Infer a message type from a destination e-mail address.
    ' address - an e-mail address.
    Private Shared Function InferMessageType(ByVal address As String) As MessageType
        Dim type As MessageType = MessageType.MIME
        '...
        Return type
    End Function 'InferMessageType


    '
    ' Create a Security object appropriate for signing this message.
    '
    Private Function CreateSecurity() As Security
        Dim s As Security = Nothing
        '...
        Return s
    End Function 'CreateSecurity


    '
    ' Create a MessageSender object appropriate for the type of
    ' message being sent.
    '
    Private Sub CreateMessageSender(ByVal msg As Message)
    End Sub 'CreateMessageSender

    ' ...

End Class 'MessageCreator
